/*
 * Unix_QrfeHidDevice.h
 *
 *  Created on: 14.11.2008
 *      Author: stefan.detter
 */

#ifndef UNIX_QRFEHIDDEVICE_H_
#define UNIX_QRFEHIDDEVICE_H_

#include "../inc/QrfeHidBase.h"

class Unix_QrfeHidDevice : public QrfeHidBase
{
	Q_OBJECT

public:
	Unix_QrfeHidDevice(QObject* parent = 0);
	Unix_QrfeHidDevice(QString devicePath, QObject* parent = 0);

	virtual void timeouts(quint32 &getReportTimeout, quint32 &setReportTimeout);
	virtual void setTimeouts(quint32 getReportTimeout, quint32 setReportTimeout);

	QString getSerialString();

	virtual bool open ( OpenMode mode = QIODevice::ReadWrite );
	virtual bool open ( QString devicePath, OpenMode mode = QIODevice::ReadWrite );
	virtual void close ();

	virtual bool isOpen();

	virtual qint64 bytesAvailable () const;
	virtual qint64 bytesToWrite () const;
	virtual bool canReadLine () const;
	virtual bool isSequential () const;

	virtual bool flush();

protected:
	virtual qint64 readData ( char * data, qint64 maxSize );
	virtual qint64 writeData ( const char * data, qint64 maxSize );

	virtual void resetDeviceData();

};

#endif /* UNIX_QRFEHIDDEVICE_H_ */
